-- Kozak-5 APC by Currenthill

-- Chassis
GT_t.CH_t.Kozak5 = {
	life = 2,
	mass = 12000,
	length = 6.1,
	width = 2.5,
	max_road_velocity = 33.3,
	max_slope = 0.2,
	fordingDepth = 1.2,
	engine_power = 279,
	engineMinRPM = 600,
	engineMaxPowerRPM = 2600,
	engineMaxRPM = 2800,
	gearRatios = { -5.0, 0.0, 4.59, 2.25, 1.54, 1.00, 0.75, 0.65},
	mainGearRatio = 4.60,
	automaticTransmission = true,		
	max_vert_obstacle = 0.4,
	max_acceleration = 6.5,
	min_turn_radius = 8.9,
	X_gear_1 = 1.90,
	Y_gear_1 = 0,
	Z_gear_1 = 1.01,
	X_gear_2 = -1.71,
	Y_gear_2 = 0,
	Z_gear_2 = -1.01,
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.39,
	armour_thickness = 0.002,	
}

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_vehicle);
set_recursive_metatable(GT.chassis, GT_t.CH_t.Kozak5);

GT.visual.shape = "Kozak5";
GT.visual.shape_dstr = "Kozak5-dest";
GT.toggle_alarm_state_interval = 1.0;

GT.swing_on_run = false;
GT.IR_emission_coeff = 0.05

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 3.3;

-- Burning after hit
GT.visual.fire_size = 0.6; --relative burning size
GT.visual.fire_pos[1] = -0.35; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 1.3; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 60; --burning time (seconds)
GT.visual.dust_pos = {1.01, 0.06, 0}
GT.visual.dirt_pos = {-1.01, 0.08, 0}


GT.driverViewConnectorName = {"POINT_DRIVER_01", offset = {0.0, 0.0, 0.0}}
GT.driverCockpit = "DriverCockpit/DriverCockpitWithLLTV"

-- weapon systems
GT.WS = {};
GT.WS.maxTargetDetectionRange = 5000;
GT.WS.smoke = {"POINT_SMOKE_01", "POINT_SMOKE_02", "POINT_SMOKE_03", 
				"POINT_SMOKE_04", "POINT_SMOKE_05", "POINT_SMOKE_06"};
GT.WS.fire_on_march = true;

-- ================================ NSVT 12.7 mm machine gun =========================================

ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_01' 
GT.WS[ws].pointer = "POINT_SIGHT_01"; 
GT.WS[ws].cockpit = {"IronSight/IronSight", open = true};
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1 
GT.WS[ws].omegaY = math.rad(60);
GT.WS[ws].omegaZ = math.rad(60); 
GT.WS[ws].stabilizer = false;
GT.WS[ws].laser = false;
GT.WS[ws].angles = {
                    {math.rad(180), math.rad(-180), math.rad(-9), math.rad(35)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);	
GT.WS[ws].reference_angle_Z = math.rad(0);	
				

--GT.WS[1].LN[1]
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.kozak5_nsvt127);
__LN.BR[1] = { connector_name = 'POINT_GUN_01', 
							recoilArgument = 2,
							recoilTime = 60/800/2,
							case_extraction_connector 	=  'EJECTOR_1',
							shellCaseID 			= 1,
							extractionDir 			= {x = 0.0, y = -0.4, z = -1.6},
							shellCaseOrientation 	= {x = 0, y = 0, z = 0}	
							}
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 1;				
				
-- ===================================================================================================

GT.Name = "CH_Kozak5";
GT.DisplayName = _('[CH] Kozak-5 APC');
GT.DisplayNameShort = _('Kozak-5');
GT.Rate = 10;

GT.Sensors = { OPTIC = {
                    "TKN-3B day",
					"TKN-3B night",
                }
            };

GT.EPLRS = true

GT.Sensors = { 
	Mount_WS_ID = 1,
	OPTIC = {"TKN-3B day", "TKN-3B night",
                        },
	noVisualDetectorInAlarmedState = false							
            };

GT.InternalCargo = {
    nominalCapacity = 400,
    maximalCapacity = 400,
}

GT.DetectionRange  = 0;
GT.airWeaponDist = 1800
GT.ThreatRange = 1800;
GT.mapclasskey = "P0091000004";
GT.attribute = {wsType_Ground, wsType_Tank, wsType_Gun, WSTYPE_PLACEHOLDER,
                "APC",
                };
GT.category = "Armor"

GT.tags  =
{
    "Armor",
	"Scout/Recon",
}

GT.Countries = {"Ukraine"}
